/**
* \file: automounterctl.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AMC_AUTOMOUNTERCTL_H
#define AMC_AUTOMOUNTERCTL_H

#include "automounter_types.h"

typedef struct automounterctl_command_vtable_t
{
	const char *command;

	const char *command_description;

	error_code_t (*init)(void);

	error_code_t (*parse_args)(int argc, char* argv[]);

	error_code_t (*start)(void);

	void (*deinit)(void);
} automounterctl_command_vtable_t;

error_code_t automounterctl_init(int argc, char *argv[]);

error_code_t automounterctl_start(void);

void automounterctl_deinit(void);

void automounterctl_error_message(error_code_t err);

#endif
